/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.container.base;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import de.unhappycodings.quarry.client.config.ClientConfig;
import de.unhappycodings.quarry.client.gui.GuiUtil;
import de.unhappycodings.quarry.common.util.RenderUtil;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public class BaseSlot
extends SlotItemHandler {
    public static final ResourceLocation GHOST_OVERLAY = new ResourceLocation("quarry", "textures/gui/slot/ghost_overlay.png");
    public static final ResourceLocation GHOST_OVERLAY_DARK = new ResourceLocation("quarry", "textures/gui/slot/ghost_overlay_dark.png");
    private final Inventory inventory;
    private final Predicate<ItemStack> canPlace;
    public boolean isEnabled = true;
    int size;
    private Pair<Predicate<ItemStack>, ResourceLocation> overlay;
    private ItemStack[] ghostOverlays;
    private int nextGhostItemTick = 0;
    private ItemStack currentGhostItem;

    public BaseSlot(IItemHandler itemHandler, Inventory inventory, int index, int xPosition, int yPosition, ResourceLocation texture, Predicate<ItemStack> canPlace, ItemStack ... ghostOverlays) {
        super(itemHandler, index, xPosition, yPosition);
        this.inventory = inventory;
        this.size = 18;
        this.canPlace = canPlace;
        this.ghostOverlays = ghostOverlays;
    }

    public BaseSlot addGhostOverlays(Item ... ghostOverlays) {
        Object[] items = new ItemStack[ghostOverlays.length];
        for (int i = 0; i < ghostOverlays.length; ++i) {
            items[i] = new ItemStack((ItemLike)ghostOverlays[i], 1);
        }
        this.ghostOverlays = (ItemStack[])ArrayUtils.addAll((Object[])this.ghostOverlays, (Object[])items);
        return this;
    }

    public BaseSlot addGhostListOverlays(List<Item> ghostOverlays) {
        Object[] items = new ItemStack[ghostOverlays.size()];
        for (int i = 0; i < ghostOverlays.size(); ++i) {
            items[i] = new ItemStack((ItemLike)ghostOverlays.get(i), 1);
        }
        this.ghostOverlays = (ItemStack[])ArrayUtils.addAll((Object[])this.ghostOverlays, (Object[])items);
        return this;
    }

    public int getTexX() {
        return this.f_40220_ - (this.getSize() - 16) / 2;
    }

    public int getTexY() {
        return this.f_40221_ - (this.getSize() - 16) / 2;
    }

    public int getSize() {
        return this.size;
    }

    public BaseSlot setSize(int size) {
        this.size = size;
        return this;
    }

    public boolean m_5857_(@NotNull ItemStack stack) {
        this.m_6654_();
        return this.canPlace.test(stack);
    }

    public void setEnabled(boolean enable) {
        this.isEnabled = enable;
    }

    public boolean m_6659_() {
        return this.isEnabled;
    }

    public void m_6654_() {
        if (this.inventory != null) {
            this.inventory.m_6596_();
        }
    }

    public ItemStack[] getGhostOverlayItem() {
        return this.ghostOverlays;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderGhostOverlay(PoseStack stack, int x, int y) {
        if (this.getGhostOverlayItem() != null && this.getGhostOverlayItem().length > 0) {
            ++this.nextGhostItemTick;
            if (!this.m_7993_().m_41619_()) {
                return;
            }
            if (this.currentGhostItem == null || this.currentGhostItem.m_41619_()) {
                this.currentGhostItem = this.getGhostOverlayItem()[new Random().nextInt(this.getGhostOverlayItem().length)];
            }
            if (this.nextGhostItemTick % 500 == 0) {
                this.currentGhostItem = this.getGhostOverlayItem()[new Random().nextInt(this.getGhostOverlayItem().length)];
                this.nextGhostItemTick = 0;
            }
            stack.m_85836_();
            RenderUtil.renderGuiItem(this.currentGhostItem, x + this.f_40220_, y + this.f_40221_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)((Boolean)ClientConfig.enableQuarryDarkmode.get() != false ? GHOST_OVERLAY_DARK : GHOST_OVERLAY));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
            RenderSystem.m_69478_();
            RenderSystem.m_69465_();
            GuiComponent.m_93133_((PoseStack)stack, (int)(x + this.f_40220_), (int)(y + this.f_40221_), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            RenderSystem.m_69461_();
            RenderSystem.m_69482_();
            GuiUtil.reset();
            stack.m_85849_();
        }
        if (this.overlay != null && ((Predicate)this.overlay.getFirst()).test(this.m_7993_())) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            RenderSystem.m_69478_();
            RenderSystem.m_69465_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)((ResourceLocation)this.overlay.getSecond()));
            GuiComponent.m_93133_((PoseStack)stack, (int)(x + this.f_40220_), (int)(y + this.f_40221_), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            RenderSystem.m_69461_();
            RenderSystem.m_69482_();
        }
    }
}

